cd "/Users/hausfath/Desktop/Climate Science/CRN/CRN HCN Project/"
global distance 100
global type tmax

use "pair_trend_results $type $distance.dta", clear
sort crn_id
tempfile data
save "`data'", replace

use uscrn_metadata.dta, clear
keep station_id lon lat
rename station_id crn_id
sort crn_id
merge crn_id using "`data'"
keep if _merge == 3

keep if adjustments == "adj"

gen region = "west" if lon < -110
replace region = "central" if lon >= -110 & lon <= -90
replace region = "east" if lon > -90

kdensity coef if lon < -110, gen(west_values west_density) nograph
kdensity coef if lon >= -110 & lon <= -90, gen(central_values central_density) nograph
kdensity coef if lon > -90, gen(east_values east_density) nograph

#delimit ;
	twoway 
	(line west_density west_values, lcolor(blue) lwidth(medthin))
	(line central_density central_values, lcolor(red) lwidth(medthin))
	(line east_density east_values, lcolor(green) lwidth(medthin))
	,
	ytitle("Probability Density", size(medsmall))
	xtitle("Trend Difference (Degrees C/yr)", size(medsmall))
	xlabel(-0.2(0.1)0.2,labsize(medium))
	ylabel(0(5)15, gmax glcolor(black) glpattern(dot) labsize(medium)) 
	graphregion(color(white) lcolor(ebg))
	xline(0, lcolor(black) lpattern(shortdash))
	legend(region(fcolor(white) lcolor(white)) size(small) position(12) label(1 "West")  label(2 "Central") label(3 "East") order(3 2 1) col(3))
	plotregion( m(b=0) )
	;
#delimit cr

graph export "CRN HCN Pair Density $type $distance by Region.png", replace width(1000)
